<?php

declare(strict_types=1);

require_once __DIR__ . '/tax_service.php';
require_once __DIR__ . '/tax_repo.php';
require_once APP_PATH . '/features/company/company_service.php';

function tax_components_page(): void
{
    $ctx = company_service_require_context();
    $components = tax_repo_components_list($ctx['company_id']);
    $pageTitle = 'Tax Components';

    require APP_PATH . '/templates/layout_top.php';
    ?>
    <h1>Tax Components</h1>
    <table class="data-table">
        <thead><tr><th>Name</th><th>Ledger</th><th>Type</th></tr></thead>
        <tbody>
            <?php foreach ($components as $c): ?>
            <tr><td><?= e($c['name']) ?></td><td><?= e($c['ledger_name'] ?? '-') ?></td><td><?= e($c['tax_type'] ?? '') ?></td></tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php
    require APP_PATH . '/templates/layout_bottom.php';
}

function tax_rates_page(): void
{
    $ctx = company_service_require_context();
    $rates = tax_repo_rates_list($ctx['company_id']);
    $pageTitle = 'Tax Rates';

    require APP_PATH . '/templates/layout_top.php';
    ?>
    <h1>Tax Rates</h1>
    <table class="data-table">
        <thead><tr><th>Component</th><th>Rate</th><th>From</th><th>To</th></tr></thead>
        <tbody>
            <?php foreach ($rates as $r): ?>
            <tr><td><?= e($r['component_name']) ?></td><td><?= $r['rate'] ?>%</td><td><?= e($r['effective_from']) ?></td><td><?= e($r['effective_to'] ?? '-') ?></td></tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php
    require APP_PATH . '/templates/layout_bottom.php';
}
