<?php

declare(strict_types=1);

function tax_repo_components_list(int $companyId): array
{
    $pdo = db();
    $stmt = $pdo->prepare('SELECT tc.*, l.name as ledger_name FROM tax_components tc LEFT JOIN ledgers l ON l.id = tc.ledger_id WHERE tc.company_id = ? ORDER BY tc.name');
    $stmt->execute([$companyId]);
    return $stmt->fetchAll();
}

function tax_repo_rates_list(int $companyId): array
{
    $pdo = db();
    $stmt = $pdo->prepare('SELECT tr.*, tc.name as component_name FROM tax_rates tr JOIN tax_components tc ON tc.id = tr.tax_component_id WHERE tc.company_id = ? ORDER BY tc.name, tr.effective_from');
    $stmt->execute([$companyId]);
    return $stmt->fetchAll();
}
