<?php

declare(strict_types=1);

require_once __DIR__ . '/reports_repo.php';
require_once APP_PATH . '/helpers.php';

function reports_service_trial_balance(int $companyId, int $fyId, ?string $asOfDate = null): array
{
    $rows = reports_repo_trial_balance($companyId, $fyId, $asOfDate);
    $totalDr = '0';
    $totalCr = '0';
    foreach ($rows as &$r) {
        $opDr = (string) $r['opening_debit'];
        $opCr = (string) $r['opening_credit'];
        $pd = (string) $r['period_debit'];
        $pc = (string) $r['period_credit'];
        $closingDr = decimal_add(decimal_add($opDr, $pd), '0');
        $closingCr = decimal_add(decimal_add($opCr, $pc), '0');
        $net = decimal_sub($closingDr, $closingCr);
        if (decimal_compare($net, '0') >= 0) {
            $r['closing_debit'] = $net;
            $r['closing_credit'] = '0';
        } else {
            $r['closing_debit'] = '0';
            $r['closing_credit'] = decimal_sub('0', $net);
        }
        $totalDr = decimal_add($totalDr, $r['closing_debit']);
        $totalCr = decimal_add($totalCr, $r['closing_credit']);
    }
    return ['rows' => $rows, 'total_dr' => $totalDr, 'total_cr' => $totalCr];
}
