<?php

declare(strict_types=1);

require_once __DIR__ . '/masters_repo.php';

function masters_service_create_group(array $data): int
{
    if (empty(trim($data['name'] ?? ''))) {
        throw new InvalidArgumentException('Group name is required.');
    }
    $validNatures = ['ASSET', 'LIABILITY', 'EQUITY', 'INCOME', 'EXPENSE'];
    if (!in_array($data['nature'] ?? '', $validNatures)) {
        throw new InvalidArgumentException('Invalid nature.');
    }
    return masters_repo_group_create($data);
}

function masters_service_create_ledger(array $data): int
{
    if (empty(trim($data['name'] ?? ''))) {
        throw new InvalidArgumentException('Ledger name is required.');
    }
    if (empty($data['group_id'])) {
        throw new InvalidArgumentException('Account group is required.');
    }
    $validTypes = ['GENERAL', 'CUSTOMER', 'SUPPLIER', 'BANK', 'CASH', 'TAX'];
    $data['ledger_type'] = $data['ledger_type'] ?? 'GENERAL';
    if (!in_array($data['ledger_type'], $validTypes)) {
        $data['ledger_type'] = 'GENERAL';
    }
    return masters_repo_ledger_create($data);
}

function masters_service_save_openings(int $fyId, array $openings): void
{
    masters_repo_openings_save($fyId, $openings);
}
