<?php

declare(strict_types=1);

function bank_repo_statements_list(int $companyId, int $ledgerId, int $page = 1, int $perPage = 50): array
{
    $pdo = db();
    $offset = ($page - 1) * $perPage;
    $stmt = $pdo->prepare('SELECT COUNT(*) FROM bank_statements WHERE company_id = ? AND ledger_id = ?');
    $stmt->execute([$companyId, $ledgerId]);
    $total = (int) $stmt->fetchColumn();
    $stmt = $pdo->prepare('SELECT * FROM bank_statements WHERE company_id = ? AND ledger_id = ? ORDER BY statement_date DESC LIMIT ? OFFSET ?');
    $stmt->execute([$companyId, $ledgerId, $perPage, $offset]);
    return ['items' => $stmt->fetchAll(), 'total' => $total];
}
