<?php

declare(strict_types=1);

require_once __DIR__ . '/bank_service.php';
require_once __DIR__ . '/bank_repo.php';
require_once APP_PATH . '/features/company/company_service.php';
require_once APP_PATH . '/features/masters/masters_repo.php';

function bank_statements_page(): void
{
    $ctx = company_service_require_context();
    $bankLedgers = array_filter(masters_repo_ledgers_list($ctx['company_id']), fn($l) => $l['ledger_type'] === 'BANK');
    $ledgerId = isset($_GET['ledger_id']) ? (int) $_GET['ledger_id'] : (reset($bankLedgers)['id'] ?? 0);
    $pageTitle = 'Bank Statements';

    require APP_PATH . '/templates/layout_top.php';
    ?>
    <h1>Bank Statements</h1>
    <form method="get">
        <input type="hidden" name="r" value="bank/statements">
        <select name="ledger_id" onchange="this.form.submit()">
            <option value="">-- Select Bank --</option>
            <?php foreach ($bankLedgers as $l): ?>
            <option value="<?= $l['id'] ?>" <?= $ledgerId == $l['id'] ? 'selected' : '' ?>><?= e($l['name']) ?></option>
            <?php endforeach; ?>
        </select>
    </form>
    <p>Import and reconciliation features can be added here.</p>
    <?php
    require APP_PATH . '/templates/layout_bottom.php';
}

function bank_reconcile_page(): void
{
    $ctx = company_service_require_context();
    $pageTitle = 'Bank Reconciliation';

    require APP_PATH . '/templates/layout_top.php';
    ?>
    <h1>Bank Reconciliation</h1>
    <p>Match bank statement lines with voucher lines.</p>
    <?php
    require APP_PATH . '/templates/layout_bottom.php';
}
