<?php

declare(strict_types=1);

require_once __DIR__ . '/auth_repo.php';

function auth_login_page(): void
{
    if (auth_check()) {
        redirect_route('company/dashboard');
        return;
    }
    $pageTitle = 'Login';
    require APP_PATH . '/templates/layout_top.php';
    ?>
    <div class="login-box">
        <h1>Accounting System</h1>
        <form method="post" action="?r=login_post">
            <?= csrf_field() ?>
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required autofocus
                       value="<?= e(old('username', '')) ?>">
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit" class="btn btn-primary">Login</button>
        </form>
    </div>
    <?php
    require APP_PATH . '/templates/layout_bottom.php';
}

function auth_login_post(): void
{
    csrf_verify();
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($username === '' || $password === '') {
        $_SESSION['_old'] = ['username' => $username];
        flash_set('error', 'Username and password are required.');
        redirect_route('login');
    }

    $user = auth_repo_find_by_username($username);
    if (!$user || !password_verify($password, $user['password_hash'])) {
        $_SESSION['_old'] = ['username' => $username];
        flash_set('error', 'Invalid credentials.');
        redirect_route('login');
    }

    if (empty($user['is_active'])) {
        flash_set('error', 'Account is disabled.');
        redirect_route('login');
    }

    auth_login($user);
    $_SESSION['user_permissions'] = null; // Force reload
    flash_set('success', 'Welcome, ' . ($user['name'] ?: $user['username']) . '!');
    redirect_route('company/dashboard');
}

function auth_logout_action(): void
{
    auth_logout();
    redirect_route('login');
}
