<?php

declare(strict_types=1);

require_once __DIR__ . '/users_repo.php';

function users_service_create(array $data): int
{
    if (empty(trim($data['username'] ?? ''))) {
        throw new InvalidArgumentException('Username is required.');
    }
    if (empty($data['password'] ?? '')) {
        throw new InvalidArgumentException('Password is required.');
    }
    if (users_repo_find_by_username($data['username'])) {
        throw new InvalidArgumentException('Username already exists.');
    }
    $id = users_repo_create($data);
    $roleIds = array_map('intval', $data['roles'] ?? []);
    if (!empty($roleIds)) {
        users_repo_set_roles($id, $roleIds);
    }
    return $id;
}

function users_service_update(int $id, array $data): void
{
    $user = users_repo_find($id);
    if (!$user) {
        throw new InvalidArgumentException('User not found.');
    }
    if (empty(trim($data['username'] ?? ''))) {
        throw new InvalidArgumentException('Username is required.');
    }
    if (users_repo_find_by_username($data['username'], $id)) {
        throw new InvalidArgumentException('Username already exists.');
    }
    $update = [
        'username' => $data['username'],
        'email' => $data['email'] ?? '',
        'name' => $data['name'] ?? $data['username'],
        'is_active' => $data['is_active'] ?? 1,
    ];
    if (!empty($data['password'])) {
        $update['password'] = $data['password'];
    }
    users_repo_update($id, $update);
    $roleIds = array_map('intval', $data['roles'] ?? []);
    users_repo_set_roles($id, $roleIds);
}
