<?php

declare(strict_types=1);

require_once __DIR__ . '/posting_engine.php';
require_once __DIR__ . '/vouchers_repo.php';

function vouchers_service_post(array $data): int
{
    $lines = [];
    foreach ($data['lines'] ?? [] as $line) {
        $dr = (float) ($line['debit'] ?? 0);
        $cr = (float) ($line['credit'] ?? 0);
        if ($dr > 0 || $cr > 0) {
            $lines[] = [
                'ledger_id' => (int) $line['ledger_id'],
                'debit' => $dr,
                'credit' => $cr,
                'narration' => $line['narration'] ?? null,
            ];
        }
    }

    return post_voucher(
        (int) $data['company_id'],
        (int) $data['fy_id'],
        $data['voucher_type'] ?? 'JOURNAL',
        $data['voucher_date'],
        $data['narration'] ?? null,
        $lines,
        null,
        null
    );
}
