<?php

declare(strict_types=1);

function vouchers_repo_next_number(int $companyId, int $fyId, string $type): string
{
    $pdo = db();
    // Must be called within an active transaction (e.g. from post_voucher)
    $stmt = $pdo->prepare('SELECT id, last_number FROM voucher_sequences WHERE company_id = ? AND financial_year_id = ? AND voucher_type = ? FOR UPDATE');
    $stmt->execute([$companyId, $fyId, $type]);
    $row = $stmt->fetch();
    $next = 1;
    if ($row) {
        $next = (int) $row['last_number'] + 1;
        $pdo->prepare('UPDATE voucher_sequences SET last_number = ? WHERE id = ?')->execute([$next, $row['id']]);
    } else {
        $pdo->prepare('INSERT INTO voucher_sequences (company_id, financial_year_id, voucher_type, last_number) VALUES (?, ?, ?, ?)')->execute([$companyId, $fyId, $type, $next]);
    }
    return $type . '-' . str_pad((string) $next, 5, '0', STR_PAD_LEFT);
}

function vouchers_repo_list(int $companyId, int $fyId, int $page = 1, int $perPage = 20): array
{
    $pdo = db();
    $offset = ($page - 1) * $perPage;

    $stmt = $pdo->prepare('SELECT COUNT(*) FROM vouchers WHERE company_id = ? AND financial_year_id = ? AND is_deleted = 0');
    $stmt->execute([$companyId, $fyId]);
    $total = (int) $stmt->fetchColumn();

    $stmt = $pdo->prepare('SELECT * FROM vouchers WHERE company_id = ? AND financial_year_id = ? AND is_deleted = 0 ORDER BY voucher_date DESC, id DESC LIMIT ? OFFSET ?');
    $stmt->execute([$companyId, $fyId, $perPage, $offset]);
    $rows = $stmt->fetchAll();

    return ['items' => $rows, 'total' => $total];
}

function vouchers_repo_find(int $id): ?array
{
    $pdo = db();
    $stmt = $pdo->prepare('SELECT v.* FROM vouchers v WHERE v.id = ?');
    $stmt->execute([$id]);
    return $stmt->fetch() ?: null;
}

function vouchers_repo_lines(int $voucherId): array
{
    $pdo = db();
    $stmt = $pdo->prepare('SELECT vl.*, l.name as ledger_name FROM voucher_lines vl JOIN ledgers l ON l.id = vl.ledger_id WHERE vl.voucher_id = ? ORDER BY vl.sort_order');
    $stmt->execute([$voucherId]);
    return $stmt->fetchAll();
}
