<?php

declare(strict_types=1);

function auth_user(): ?array
{
    return $_SESSION['user'] ?? null;
}

function auth_id(): ?int
{
    return auth_user()['id'] ?? null;
}

function auth_check(): bool
{
    return auth_user() !== null;
}

function auth_require(): void
{
    if (!auth_check()) {
        flash_set('error', 'Please log in to continue.');
        redirect_route('login');
    }
}

function auth_login(array $user): void
{
    session_regenerate_id(true);
    $_SESSION['user'] = [
        'id' => (int) $user['id'],
        'username' => $user['username'],
        'email' => $user['email'] ?? '',
        'name' => $user['name'] ?? $user['username'],
    ];
}

function auth_logout(): void
{
    $_SESSION = [];
    if (ini_get('session.use_cookies')) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
    }
    session_destroy();
}
