# Core PHP Accounting System

A feature-based PHP 8.2+ accounting system (no MVC, no framework) with MySQL/MariaDB, PDO, session auth, and server-rendered HTML.

## Requirements

- PHP 8.2+
- MySQL 5.7+ or MariaDB 10.3+
- Apache (XAMPP) or nginx with PHP-FPM

## Installation

1. **Create database**

   ```sql
   CREATE DATABASE accounting2 CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
   ```

2. **Run schema**

   ```bash
   mysql -u root accounting2 < storage/database/schema.sql
   ```

3. **Create admin user**

   ```bash
   php storage/install.php
   ```

   Default: `admin` / `admin123` (change after first login)

4. **Configure environment**

   Copy `.env.example` to `.env` and adjust DB and APP settings.

5. **Point web root**

   Point the document root to `public/`:

   - XAMPP: Place project in `htdocs/accounting2`, access `http://localhost/accounting2/public/`
   - Or use a virtual host with `DocumentRoot` set to `public`

## Structure

```
/public          - index.php entry, assets
/app
  bootstrap.php  - config, session, autoload
  config.php, db.php, auth.php, csrf.php, permissions.php, helpers.php
  router.php     - ?r=route/path
  /features
    /company     - company_pages, company_service, company_repo
    /masters     - COA, ledgers, openings
    /accounts    - vouchers, posting_engine
    /sales       - sales invoices
    /purchase    - purchase bills
    /tax         - tax components/rates
    /reports     - TB, ledger, P&L, BS, daybook
    /bank        - bank statements, reconciliation
    /admin       - users, roles, audit
  /templates     - layout, partials
/storage         - database, logs, uploads
```

## Routes (examples)

- `?r=login` - Login
- `?r=company/dashboard` - Dashboard (select company/FY)
- `?r=masters/groups` - Chart of Accounts
- `?r=masters/ledgers` - Ledgers
- `?r=masters/openings` - Opening balances
- `?r=accounts/vouchers` - Vouchers list
- `?r=accounts/voucher/new` - New voucher
- `?r=sales/invoices` - Sales invoices
- `?r=purchase/bills` - Purchase bills
- `?r=reports/trial_balance` - Trial balance
- `?r=admin/users` - Users (admin)

## Posting Engine

All voucher creation goes through `post_voucher()` in `app/features/accounts/posting_engine.php`:

- Validates date within FY
- Checks period lock
- Ensures debits = credits
- Generates voucher_no via row lock
- Writes audit log

## Security

- CSRF on all POST routes
- `password_hash` / `password_verify`
- RBAC via roles and permissions
- Period lock enforcement
- Soft delete for vouchers
